overall_rating();

function overall_rating() {
    let template = Template.GetCurrent();
    let models = ["M1"];
    // Duke Xiao 18-Jul-2025 - Combine WC 1-6 7-8 in CNCAP_2024_Far_Side_VTC_Single_Occupant_1-8_CN.ort
    if (template.filename.includes("CNCAP_2024_Far_Side_VTC_Single_Occupant")) {
        models = ["CASE_7", "CASE_8"];
    }
    /* Create a status object to track whether REPORTER Variables are all present and valid.
     * <success> is initially true but will be set to false if anything missing or invalid. */
    let status = { success: true, missing: [], invalid: [] };

    for (let m of models) {
        let head_score = get_variable_value(status, `${m}_HEAD_FINAL_SCORE`, "float");
        let chest_score = get_variable_value(status, `${m}_CHEST_ABDOMEN_FINAL_SCORE`, "float");

        let total_score = head_score + chest_score;

        /** Check if capping limit is "TRUE" for any body region or head excursion zone
         * If it is then total score will automatically be zero. Add an asterisk to the score to indicate that it has been capped. */
        let overal_capping = "FALSE";
        for (let rep_var of Variable.GetAll(template)) {
            if (rep_var.name.endsWith("CAPPING_LIMIT") && rep_var.name.startsWith(`${m}_`) && rep_var.value == "TRUE") {
                total_score = "*0";
                overal_capping = "TRUE";
                break;
            }
        }

        /** create the "CAPPING_LIMIT" variable  */
        new Variable(template, `${m}_CAPPING_LIMIT`, "Capping Limit", overal_capping, "General", false, true);

        new Variable(
            template,
            `${m}_TOTAL_SCORE`,
            "head + chest & abdomen (0 if any capping limit is TRUE)",
            total_score,
            "General",
            false,
            true
        );
        new Variable(
            template,
            `${m}_MAX_POSSIBLE_SCORE`,
            "Maximum score for Far Side Assessment",
            "8",
            "General",
            false,
            true
        );

        /* Variables for use in summary template */
        new Variable(
            template,
            "SUMMARY_HEAD_SCORE",
            "Head Score used in summary template",
            head_score,
            "General",
            false,
            true
        );
        new Variable(
            template,
            "SUMMARY_THORAX_ABDOMEN_SCORE",
            "Thorax Abdomen Score used in summary template",
            chest_score,
            "General",
            false,
            true
        );
        new Variable(
            template,
            "SUMMARY_TOTAL_SCORE",
            "Score used in summary template",
            total_score,
            "General",
            false,
            true
        );

        /* This is needed so the summary template does not show missing data error */
        new Variable(template, "CFA", "Correlation Factor A", "", "General", false, true);
    }
}
